
require( "scripts/style.lua" );

AdventurePlayFont = {
  standardFont,
  45,
  Color(102,9,9,255),
}

AdventureFont = {
  standardFont,
  18,
  Color(102,9,9,255),
}

ActivityPlayFont = {
  standardFont,
  30,
  Color(165,82,48,255),
}

ActivityFont = {
  standardFont,
  10,
  Color(165,82,48,255),
}

kButtonSpacingY = 1;
kButtonSpacingX = 112;

kButtonY = 60 - kButtonSpacingY;	-- DBF moving it up a row to make room for medals and options
kButtonX = 207;

menu_fly_speed = 1;
menu_fly_accel = 1;

function loaderror()
	local answer;
	gDialogTable = { 
		body = "LOADFAILED_body",
		title = "LOADFAILED_title",
		yes = function()
			answer = "yes";
		end;
		no = function()
			answer = "no";
		end;
		};
	DoModal("scripts/ok.lua");
	return answer;
end;

function CheckUsers()
	if (GetNumUsers() == 0) then
		gEnterNameValue = "";
		name = DoModal("scripts/entername.lua");
		if (not(name == nil)) then
			CreateNewUser(name);
			return true ;
		end
		return false ;
	else
		return true;
	end
end

function QuitGame()
	CloseWindow();
end

function confirmnewgame()
	local answer;
	gDialogTable = { 
		body = "CONFIRMNEWGAME_body",
		title = "CONFIRMNEWGAME_title",
		yes = function()
			answer = "yes";
		end;
		no = function()
			answer = "no";
		end;
		};
	DoModal("scripts/yesno.lua");
	return answer;
end;

MakeDialog
{
	-- Name the modal dialog
	name="mainmenu",
	TMainMenu
	{
		fit=true;
		Bitmap
		{
			name = "backgroundimage",
			image = "backgrounds/mainmenu",

			-- tMenuSprite { x = 0, y = 0, file = "anim/mainmenu/petrablink", anim = "Blink", },
			-- tMenuSprite { x = 0, y = 0, file = "anim/mainmenu/mainmenu", anim = "DoAnim", },
			-- full screen window
			-- tMenuParty { x = 0, y = 0, w = kMax, h = kMax, px = 600, py = 300, file = "anim/mainmenu/filmdots.lua", },
			-- partial screen window
			-- tMenuParty { x = 0, y = 0, w = kMax, h = kMax, px = 600, py = 300, file = "anim/mainmenu/filmlines.lua", },
			-----------------------------
			-- Welcome, PlayerName
			-----------------------------
			--SetStyle( LongButtonStyle ),
			
			tAnimatedWindow 
			{
				name = "group_name_panel",
				x = 900, y = 0, w = kMax+900, h = kMax, 
				speed = menu_fly_speed, accel = menu_fly_accel,
				desired_x = 400,
				desired_y = 0,
				sound = "audio/sfx/dialog_slide.ogg",
				on_finish = "UpdateEndGame()",
				
				Bitmap
				{
					image = "backgrounds/changeplayer_panel",
					mask = exists("backgrounds/changeplayer_panel.mask.png"),
				};
				
				Bitmap
				{
					image = "backgrounds/name_slot",
					mask = exists("backgrounds/name_slot.mask.png"),
				};
			
				Text
				{
					font = WelcomeFont,
					name = "welcome",
					label = "welcome",
					x = 65, y = 19,
					w = kMax,
					h = 50,
					flags = kHAlignLeft + kVAlignTop,
				};
				
				-----------------------------
				-- PLAY GAME
				-----------------------------
				SetStyle( AdventureButtonStyle ),
				Button
				{
					x = 65,
					y = 45,
					name="play_game",
					label = "",
					type = kPush,
					command = function()
						if (CheckUsers()) then
							SetCurrentGameMode(0);	-- Tell TSettings what game mode we're entering
							if IsSavedGamePresent() then
								--[[
								if confirmnewgame() ~= "yes" then
									-- don't launch new game
									return;
								end;
								--]]
								if SetStartMode(STARTMODE.LOAD) then
									-- Open a game window
									game:Set("activity_mode", 0);
									SwapToModal("scripts/game.lua");
								else
									loaderror();
								end
							else
								if SetStartMode(STARTMODE.NEW) then
									SwapToModal("scripts/game.lua");
								else
									loaderror();
								end;
							end
						end
					end
				},
				
				Text
				{
					font = AdventurePlayFont,
					name = "playadventure",
					label = "play",
					x = 65, y = 50,
					w = 115,
					h = 55,
					flags = kHAlignCenter + kVAlignTop,
				},
				
				Text
				{
					font = AdventureFont,
					name = "adventure",
					label = "MAIN_adventure",
					x = 65, y = 50,
					w = 115,
					h = 55,
					flags = kHAlignCenter + kVAlignBottom,
				},
				
				-----------------------------
				-- Activity Mode
				-----------------------------
				SetStyle( ActivityButtonStyle ),
				Button
				{
					x = 194,
					y = 70,
					name = "activitymode",
					label = "",
					type = kPush,
					command = function()
						if (CheckUsers()) then
							if SetStartMode(STARTMODE.ACTIVITY) then
								DoModal("scripts/activitymode.lua");
							else
								loaderror();
							end;
						end
					end
				},
				
				SetStyle( ActivityButtonUnlockStyle ),
				Button
				{
					x = 194,
					y = 70,
					name = "activitymodeunlock",
					label = "",
					type = kPush,
					command = function()
						if (CheckUsers()) then
							game:Set("activity_unlocked", 0);
							game:SaveGame();
							UpdateActivityUnlock();
							if SetStartMode(STARTMODE.ACTIVITY) then
								DoModal("scripts/activitymode.lua");
							else
								loaderror();
							end;
						end
					end
				},
				
				Text
				{
					font = ActivityPlayFont,
					name = "playactivities",
					label = "play",
					x = 195, y = 75,
					w = 71,
					h = 35,
					flags = kHAlignCenter + kVAlignTop,
				},
				
				Text
				{
					font = ActivityFont,
					name = "activities",
					label = "activitymode",
					x = 193, y = 75,
					w = 71,
					h = 35,
					flags = kHAlignCenter + kVAlignBottom,
				},
				
				-----------------------------
				-- CHANGE PLAYER
				-----------------------------
				SetStyle( ChangePlayerButtonStyle ),
				Button
				{
					--x = kButtonX + (kButtonSpacingX * 4),
					--y = kButtonY,
					x = 180,
					y = 45,
					name = "changeplayer",
					label = "changeplayer",
					type = kPush,
					command = function()
						DoModal("scripts/chooseplayer.lua");
					end
				},
				
				TFXWindow
				{
					x = 0, y = 0,
					w = 800, h = 600,
					fx = "fx/afpfx_playbutton_highlight_container.lua",
					locx = 0,
					locy = 300
				},
			};
			
			-----------------------------
			-- AVENUE FLO A Diner Dash Adventure
			-----------------------------
			--[[
			Text
			{
				font = DialogTitleFont,
				name = "avenueFlo",
				label = "avenueFlo",
				x = 470, y = 10,
				w = kMax,
				h = 150,
				flags = kHAlignCenter + kVAlignCenter,
				
			};
			-]]
			-----------------------------
			-- Version
			-----------------------------
			
			--SetStyle( LongButtonStyle ),
			--[[
			Text
			{
				font = DialogTitleFont,
				name = "version",
				label = "6.0",
				x = 5, y = 0,
				w = 100,
				h = 50,
				flags = kHAlignLeft,-- + kVAlignCenter,
			};
			--]]
--[[			
			-----------------------------
			-- LOAD GAME
			-----------------------------
			SetStyle( GreenButtonStyle ),
			Button
			{
				x = kButtonX + (kButtonSpacingX * -2),
				y = kButtonY,
				name = "load_game",
				label = "MAIN_resumegame",
				type = kPush,
				command = function()
					if (CheckUsers()) then
						-- Tell TSettings what game mode we're entering
						SetCurrentGameMode(0);
						
						if SetStartMode(STARTMODE.LOAD) then
							-- Open a game window
							SwapToModal("scripts/game.lua");
						else
							loaderror();
						end
					end
				end
			},

			-----------------------------
			-- RESUME GAME
			-----------------------------
			Button
			{
				x = kButtonX + (kButtonSpacingX * 2),
				y = kButtonY + (kButtonSpacingY * 1),
				name="resume_game",
				label = "MAIN_resumegame",
				type = kPush,
				command = function()
					if (CheckUsers()) then
						-- Tell TSettings what game mode we're entering
						SetCurrentGameMode(0);
						
						SetStartMode(STARTMODE.RESUME);
						
						-- Switch to the appropriate screen
						SwapToModal("scripts/game.lua");
					end
				end
			},
--]]
			SetStyle( ButtonStyle ),

--[[
			Button
			{
				x = kButtonX + (kButtonSpacingX * -1),
				y = kButtonY,
				name = "awards",
				label = "awards",
				type = kPush,
				command = function()
					cansubmit = true;
					DoModal("diary/awards.lua");
				end
			},
	--]]		
	
			tAnimatedWindow 
			{
				name = "group_options_panel",
				x = 150, y = 1000, w = kMax, h = kMax+650, 
				speed = menu_fly_speed, accel = menu_fly_accel,
				desired_x = 150,
				desired_y = 500,
				sound = "",
				
				Bitmap
				{
					image = "backgrounds/bottom_panel",
					mask = exists("backgrounds/bottom_panel.mask.png"),
				},
				
				Button
				{
					x = kButtonX + (kButtonSpacingX * -1),
					y = kButtonY,
					name = "medals",
					label = "medals",
					type = kPush,
					command = function()
						cansubmit = true;
						DoModal("scripts/medals.lua");
						--DoModal("diary/awards.lua");
					end
				},
				
				Button
				{
					x = kButtonX,
					y = kButtonY,
					name = "highscores",
					label = "highscores",
					type = kPush,
					command = function()
						DoModal("scripts/hiscore.lua");
					end
				},
				
				Button
				{
					x = kButtonX + (kButtonSpacingX * 1),
					y = kButtonY,
					name = "options",
					label = "options",
					type = kPush,
					command = function()
						DoModal("scripts/options.lua");
					end
				},
				
				Button
				{
					x = kButtonX + (kButtonSpacingX * 2),
					y = kButtonY,
					name = "help",
					label = "help",
					type = kPush,
					command = function()
						MET_BeginHelp();
						DoModal("scripts/help.lua");
						MET_EndHelp();
					end
				},
				
				Button
				{
					x = kButtonX + (kButtonSpacingX * 3),
					y = kButtonY,
					name = "quit",
					label = "quit",
					type = kPush,
					command= function()
						result = dfDisplayDialog {
							"scripts/yesno.lua",
							body = "quit_app_body",
							title = "quit_app_title"
						};
						if (result=='yes') then
							PostMessage( CreateNamedMessage( kQuitNow, "Quit" ) );
						end
					end
				},
				
				-----------------------------
				-- Copyright
				-----------------------------
				Text
				{
					font = SmallButtonFont,
					name = "copyright",
					label = "copyright",
					x = 342, y = 33,
					w = 300,
					h = 50,
					flags = kHAlignRight,-- + kVAlignCenter,
				},
			},
			
			tAnimatedWindow
			{
				name = "group_moregames_panel",
				x = -500, y = 500, w = kMax+500, h = kMax, 
				speed = menu_fly_speed, accel = menu_fly_accel,
				desired_x = 0,
				desired_y = 500,
				sound = "",
				
				Bitmap
				{
					image = "backgrounds/moregames_panel",
					mask = exists("backgrounds/moregames_panel.mask.png"),
				},
				-----------------------------
				-- XSELL MORE GAMES
				-----------------------------
				SetStyle( ButtonStyle ),
				Button
				{
					x = 14,
					y = kButtonY,
					name = "moregames",
					label = "moregames",
					type = kPush,
					command = function()
						DoModal("xsell/xsell.lua");
					end
				},
			},
			
			Bitmap
			{
				image = "backgrounds/flo",
				mask = exists("backgrounds/flo.mask.png"),
			};
			
			-----------------------------
			-- CHOOSE SCENE
			-----------------------------
			SetStyle( ButtonStyle ),
			Button
			{
				x = kButtonX + 150 + (kButtonSpacingX * -1),
				y = kButtonY + 400,
				name="choosescene",
				label="choosescene",
				type = kPush,
				command = function()
					if (CheckUsers()) then
						if DoModal("scripts/choosescene.lua") then
							SwapToModal("scripts/game.lua");
						end;
					end;
				end;
			},
			
			TFXWindow
			{
				x = 0, y = 0,
				w = 800, h = 600,
				fx = "fx/afpfx_logo_shine_container.lua",
				locx = 400,
				locy = 300
			},
		},
	}
}


function UpdateCheat()
	local cheatmode = IsEnabled(kCheatMode);
	EnableWindow('choosescene', cheatmode);
end

function UpdateFirstPeek()
	local firstpeek = IsFirstPeek();--GetConfig(kFirstPeek);
	EnableWindow('highscores',firstpeek==false);
	EnableWindow('activitymode',firstpeek==false);
	EnableWindow('playactivities',firstpeek==false);
	EnableWindow('activities',firstpeek==false);
end

function UpdateEndGame()
	if game:Get("game_just_over") == 1 then
		DoModal("scripts/endgame.lua");
		game:Set("game_just_over", 0);
	end
end

function UpdateActivityUnlock()
	if game:Get("activity_unlocked") > 0 then
		EnableWindow("activitymode", false);
		EnableWindow("activitymodeunlock", true);
	else
		EnableWindow("activitymodeunlock", false);
		EnableWindow("activitymode", true);
	end
end

UpdateCheat();
UpdateFirstPeek();
UpdateActivityUnlock();